const express = require('express');
const bodyParser = require('body-parser');
const connection = require('./database');
const path = require('path');
const cors = require('cors');

const app = express();
app.use(cors());
app.use(bodyParser.urlencoded({ extended: true }));

app.set('view engine', 'ejs');
app.set('views', path.join(__dirname, 'views'));
app.use(express.static(path.join(__dirname, 'public')));

// 📌 Route: Show All Users
app.get('/', (req, res) => {
    connection.query('SELECT * FROM users', (err, results) => {
        if (err) throw err;
        res.render('index', { users: results });
    });
});

// 📌 Route: Show Add User Form
app.get('/add', (req, res) => {
    res.render('add');
});

// 📌 Route: Add User (POST)
app.post('/add', (req, res) => {
    const { name, email } = req.body;
    connection.query('INSERT INTO users (name, email) VALUES (?, ?)', [name, email], (err) => {
        if (err) throw err;
        res.redirect('/');
    });
});

// 📌 Route: Show Edit Form
app.get('/edit/:id', (req, res) => {
    const userId = req.params.id;
    connection.query('SELECT * FROM users WHERE id = ?', [userId], (err, results) => {
        if (err) throw err;
        res.render('edit', { user: results[0] });
    });
});

// 📌 Route: Update User (POST)
app.post('/update/:id', (req, res) => {
    const { name, email } = req.body;
    const userId = req.params.id;
    connection.query('UPDATE users SET name = ?, email = ? WHERE id = ?', [name, email, userId], (err) => {
        if (err) throw err;
        res.redirect('/');
    });
});

// 📌 Route: Delete User
app.get('/delete/:id', (req, res) => {
    const userId = req.params.id;
    connection.query('DELETE FROM users WHERE id = ?', [userId], (err) => {
        if (err) throw err;
        res.redirect('/');
    });
});

// 📌 Start Server
const PORT = 3000;
app.listen(PORT, () => {
    console.log(`Server running on http://localhost:${PORT}`);
});
